#include "serveur.h"

//constructeur par defaut
Serveur::Serveur(int iNbClients)
: m_iNbClients(iNbClients)
{
    //initialise le rseau
    WSADATA WSAData;
    WSAStartup(MAKEWORD(2,0), &WSAData);
    
    int ret;
    
    // creation du socket de connection des clients
    this->m_Socket = socket(AF_INET,SOCK_STREAM,0);
    if ( this->m_Socket == -1)
    {
        printf("erreur de creation de socket !\n");
        exit(1);
    }
    
    // remplissage de la structure contenant l'adresse
    this->m_Adresse.sin_addr.s_addr	= htonl(INADDR_ANY);
    this->m_Adresse.sin_family		= AF_INET;
    this->m_Adresse.sin_port		= htons(23023);
    
    // inscription du socket au systeme
    ret = bind(this->m_Socket, (SOCKADDR *)&this->m_Adresse, sizeof(this->m_Adresse));
    if (ret==-1)
    {
        printf("erreur d'inscription du socket au systeme\n");
        exit(1);
    }
    
    // mise en place de la file d'attente de connection
    ret=listen(this->m_Socket, 10);
    if (ret==-1)
    {
        printf("erreur mise en place de la file d'attente de connection \n");
        exit(1);
    }
   
    printf("Reseau initialise avec succes\n"); 
}

 // envoie le go  tous les clients
void Serveur::sendGo()
{
    vector<Client*>::iterator i;
    
    // parcours la liste des clients
    for (i = this->m_listClient.begin(); i != this->m_listClient.end(); i++)
    {
        (*i)->sendGo();
    }
}
        
//destructeur
Serveur::~Serveur()
{
    // fermeture du rseau
    closesocket(this->m_Socket);
    WSACleanup();
}
        
//attends que tous les clients sont prts
void Serveur::waitClientsReady()
{
    vector<Client*>::iterator i;
    
    // parcours la liste des clients
    for (i = this->m_listClient.begin(); i != this->m_listClient.end(); i++)
    {
        (*i)->waitReady();
        this->sendNames(*i);
    }
}


// envoie le nom de tous les joueurs au client point par pClient
void Serveur::sendNames(Client * pClient)
{
     vector<Client*>::iterator i;
     char cNumJoueur;
     //char buffer[50];
     for (i = this->m_listClient.begin(); i != this->m_listClient.end(); i++)
     {
        if (*i!=pClient)
        {
            cNumJoueur =(*i)->getNumero();
            pClient->sendBuffer(&cNumJoueur,sizeof(cNumJoueur));
            printf("|%d|",(*i)->getNomJoueur());
            pClient->sendBuffer((*i)->getNomJoueur(),strlen((*i)->getNomJoueur()));
            // attends l'accuse de reception du client
            pClient->wait();
        }
     }
} 

// Attend la connection de tous les clients
void Serveur::acceptClients()
{
    for (int i = 0; i < this->m_iNbClients ; i++)
    {
        this->acceptUnClient();
    }
}
        
// attend la conection d'un client et ajoute ce client dans la liste
// des clients
void Serveur::acceptUnClient()
{
    SOCKET socketC; // socket de connection avec le client
    SOCKADDR_IN adresseC; // adresse du client
    int adresseCLenght;
    
    printf("Attente du joueur %d\n...",this->getNbClientsConnectes()+1);
    
    adresseCLenght = sizeof(adresseC);
    socketC = accept(this->m_Socket, (SOCKADDR *)&adresseC, &adresseCLenght);
    if ( socketC == -1)
    {
        printf("Erreur de connection avec le joueur %d\n",this->getNbClientsConnectes()+1);
        exit(1);
    }
    
    printf("Connecte avec le joueur %d\n",this->getNbClientsConnectes()+1);
    
         
    // envoie le numero du joueur au client
    char * buffer = (char *)malloc(1);
    *buffer = this->getNbClientsConnectes()+1;
    send(socketC,buffer, sizeof(*buffer),0);
    
    // evoie le nombre de joueurs
    *buffer = (char) this->m_iNbClients;
    send(socketC,buffer, sizeof(*buffer),0);
    
    // ajout du client dans la liste des clients
    this->m_listClient.push_back(new Client(this->getNbClientsConnectes()+1,socketC));
  
}
        
// rejette un client de la partie
void Serveur::kickClient(int iNumClient)
{
    vector<Client *>::iterator i;
    
    for (i=this->m_listClient.begin(); i != this->m_listClient.end() ; i++)
    {
        if ((*i)->getNumero() == iNumClient)
        {
            printf("Joueur %d deconnecte du serveur.\n",iNumClient);
            delete *i;
            this->m_listClient.erase(i);
            return;
        }
    }
    printf("Erreur : joueur %d non trouve sur le serveur !\n",iNumClient);
}

// rempli le package avec tous les evnements des clients
void Serveur::createPackage()
{
    vector<Client *>::iterator i;
    vector<char>* list;
    
    // vide le package
    this->m_Package.clearPackage();
    
    for (i=this->m_listClient.begin(); i != this->m_listClient.end() ; i++)
    {
        list = (*i)->getEvents();
        this->m_Package.addEvents((*i)->getNumero(),list);
        delete list;
    }
}  
// envoie le package  tous les clients
void Serveur::sendPackage()
{
    vector<Client *>::iterator i;
    
    for (i=this->m_listClient.begin(); i != this->m_listClient.end() ; i++)
    {
        (*i)->sendPackage(&this->m_Package);
    }
}

// retourne le nombre de clients
int Serveur::getNbClientsConnectes()
{
    return this->m_listClient.size();
}

// vrifie si tous les clients sont connects et les fait sortir de 
// la partie sinon
void Serveur::ckeckClientsConnected()
{
    vector<Client *>::iterator i;
    
    for (i=this->m_listClient.begin(); i != this->m_listClient.end() ; i++)
    {
        if ((*i)->isDisconnected())
        {
            this->kickClient((*i)->getNumero());
            // replace l'iterateur au debut de la liste
            // de faon a ne pas sortir de la liste si l'on supprime le dernier
            // element
            i=this->m_listClient.begin();
            if (i== this->m_listClient.end())
                break;
        }
    }
}
